%% Calculating Global Moran I for the datasets
close all

matrix = data_river_oriented_wanssum; %input matrix for Moran's I calculation

% Number of regions
n = numel(matrix);

% Step 1: Define function to compute rook weights
rook_weights = zeros(n, n);
for i = 1:n
    for j = 1:n
        if i ~= j && (abs(i - j) == 1 || abs(i - j) == sqrt(n))
            rook_weights(i, j) = 1;
        end
    end
end

% Step 2: Compute spatial lag
spatial_lag = sum(rook_weights, 2);

% Step 3: Compute Moran's I
mean_x = mean(matrix(:));
numerator = 0;
denominator = 0;

for i = 1:n
    xi = matrix(i);
    xi_bar = mean_x;

    for j = 1:n
        xj = matrix(j);
        w_ij = rook_weights(i, j);
        numerator = numerator + w_ij * (xi - xi_bar) * (xj - xi_bar);
     end
    denominator = denominator + (xi - xi_bar)^2;
end

moran_i = n * numerator / (sum(spatial_lag) * denominator);

% Display results
disp(['Moran''s I value: ', num2str(moran_i)]);

%% Moran's I v.s. average normalized standard deviation (protocol sampling)

x = [0.10569 0.023408 0.26794 0.073269 0.28673 -0.049663 0.23361 0.30127];
y = [0.73555 0.528975 0.416375 0.11535 0.7205 0.299875 0.523475 0.495175];

scatter(x,y,'filled','k'); lsline
xlabel('Morans I'); ylabel('Normalized standard deviation (sampling protocols)');
xlim([-.2 .4]); ylim([0 1])
fitlm(x,y);  legend({'R-squared: 0.161'})